%%Partendo dalle immagini ottenute con la segmentazione, questo script
%%restituisce i valori di distanze (euclidea) e correlazione (Pearson)

%Parametri:
% - 13 immagini
% - selected_features: array logico (vedi selectSignificantFeatures)
% - prototype: insieme di features di riferimento (vedi computePrototypeClass)
% - mu, sigma: usati per la normalizzazione dei dati (vedi calcolateBestMuAndSigmaFromData)

function [euclidean pearson complete_features] = rankGeneFromImages(ca1_border_int ,ca1_border_ext, ca1_in ,ca1_out , ...
                                                  ca3_border_int ,ca3_border_ext ,ca3_in ,ca3_out , ...
                                                  dg_border_int ,dg_border_ext, dg_in, dg_out_int ,dg_out_ext , ...
                                                  selected_features, prototype, mu, sigma)

%     addpath('functions\');

    %firstly, extract features from the 13 images
    parts     = {'ca1_border_int','ca1_border_ext','ca1_in','ca1_out',...
                 'ca3_border_int','ca3_border_ext','ca3_in','ca3_out',...
                 'dg_border_int','dg_border_ext','dg_in','dg_out_int','dg_out_ext'};

    winSizes  = {[24], [24], [14 28], [18 36],...
                 [24], [24], [14 28], [18 36],...
                 [24], [24], [14 28], [18 36], [18 36]};
    steps     = [4, 4, 6, 12,...
                 4, 4, 6, 12,...
                 4, 4, 6, 6, 12,]*3;

    MAX_WINDOWS = 50; %stop when you get enough data
    MIN_WINDOWS =  1; %at least these number of windows

    complete_features = [];
    for p=1:length(parts)

        
        sizew = winSizes{p};
        max_size = max(sizew);
        step = steps(p);
        im = eval(parts{p});%im2double(imread(strcat('images/',database,'/',char(parts{p}),'/',files_in(f).name)));

        enough = false;
        myStep = step;
        while ~enough && myStep > 0
            sumFeatures = zeros(1,11*length(sizew));
            countElements = 0;
            stop = false;
            for x=max_size+1:step:size(im,1)-max_size
                if stop
                    break;
                end
                for y=max_size+1:myStep:size(im,2)-max_size
                    win = im(x:x+max_size,y:y+max_size);
                    if all(win)
                        %analisi texture
                        countElements = countElements + 1;
                        tmpFeatures = getTextureFeatures(im,x+max_size/2,y+max_size/2,sizew);
                        tmpFeatures(isnan(tmpFeatures))=0;
                        sumFeatures = sumFeatures + tmpFeatures;
                        if countElements == MAX_WINDOWS
                            stop = true;
                            break;
                        end
                    end
                end
            end
            if countElements >= MIN_WINDOWS
                enough = true;
            else
                myStep = myStep - 1;
                if myStep == 0
%                     fprintf(1, '%s: not enough features (only %d) extracted in %s\n', files_in(f).name, countElements, char(parts{p}));
                end
            end
        end

        sumFeatures = sumFeatures/countElements;
        sumFeatures(isnan(sumFeatures)) = 0.0;
        complete_features = [complete_features sumFeatures];
%         fprintf(outfile_in, '%s', files_in(f).name);
%         fprintf(outfile_in, ' %f', sumFeatures);
%         fprintf(outfile_in,'\n');
%         fclose(outfile_in);
%         if p==1
%             fclose(outfile_names);
%         end
    end
    clear im
    complete_features = (complete_features - mu)  ./ sigma;
    complete_features = complete_features(selected_features);
    euclidean = max(max(dist([complete_features; prototype]')));
    pearson = min(min(corr([complete_features; prototype]')));
%     clear complete_features
end